/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.comm.SerialPort;

public class BufferSize
extends Panel
implements MouseListener,
ActionListener {
    private int value;
    private int defaultValue;
    private Label label;
    private TextField data;
    private SerialPort port;
    private boolean inputBuffer;

    public BufferSize(int n, SerialPort serialPort, boolean bl) {
        this.setPort(serialPort);
        this.inputBuffer = bl;
        this.setLayout(new BorderLayout());
        this.label = new Label("Buffer Size");
        this.label.addMouseListener(this);
        this.add("West", this.label);
        this.data = new TextField(new Integer(this.defaultValue).toString(), n);
        this.data.addActionListener(this);
        this.add("East", this.data);
        this.showValue();
        this.defaultValue = this.value;
    }

    public void setPort(SerialPort serialPort) {
        this.port = serialPort;
    }

    public int getValue() {
        if (this.port != null) {
            this.value = this.inputBuffer ? this.port.getInputBufferSize() : this.port.getOutputBufferSize();
            return this.value;
        }
        return 0;
    }

    public void showValue() {
        ((TextComponent)this.data).setText(new Integer(this.getValue()).toString());
    }

    public void setValue(int n) {
        if (this.port != null) {
            if (this.inputBuffer) {
                this.port.setInputBufferSize(n);
            } else {
                this.port.setOutputBufferSize(n);
            }
        }
        this.showValue();
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            Integer n = new Integer(string);
            this.setValue(n);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Bad value = " + actionEvent.getActionCommand());
            this.showValue();
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setValue(this.defaultValue);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

