/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.IOException;
import javax.comm.SerialPort;

public class Receiver
extends Panel
implements Runnable {
    private TextArea text;
    private ReceiveOptions options;
    private ByteStatistics counter;
    private SerialPortDisplay owner;
    private byte[] buffer;
    private int textCount;
    private int delay;
    private boolean silentReceive;

    public Receiver(SerialPortDisplay serialPortDisplay, int n, int n2) {
        this.owner = serialPortDisplay;
        this.buffer = new byte[2048];
        this.setLayout(new BorderLayout());
        this.options = new ReceiveOptions(serialPortDisplay.port);
        this.add("North", this.options);
        this.counter = new ByteStatistics("Bytes Received", 10, serialPortDisplay.port, true);
        this.add("South", this.counter);
        this.text = new TextArea(n, n2);
        this.add("Center", this.text);
        this.textCount = 0;
        this.delay = 0;
        this.silentReceive = false;
    }

    public Receiver(SerialPortDisplay serialPortDisplay, int n, int n2, int n3) {
        this(serialPortDisplay, n, n2);
        this.delay = n3;
    }

    public Receiver(SerialPortDisplay serialPortDisplay, int n, int n2, int n3, boolean bl) {
        this(serialPortDisplay, n, n2);
        this.silentReceive = bl;
    }

    public void setPort(SerialPort serialPort) {
        this.counter.setPort(serialPort);
        this.options.setPort(serialPort);
    }

    public void showValues() {
        this.options.showValues();
        this.counter.showValues();
    }

    public void clearValues() {
        this.text.setText("");
        this.counter.clearValues();
        this.options.clearValues();
    }

    public void setBitsPerCharacter(int n) {
        this.counter.setBitsPerCharacter(n);
    }

    public void run() {
        while (this.owner.open) {
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {}
            if (!this.owner.ctlSigs.DA) continue;
            this.readData();
        }
    }

    private String displayText(byte[] byArray, int n) {
        String string;
        if (this.textCount > 5000) {
            this.text.setText("");
            this.textCount = 0;
        }
        byte[] byArray2 = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (Character.isISOControl((char)byArray[n2]) && !Character.isWhitespace((char)byArray[n2])) {
                byArray2[n3++] = 60;
                byArray2[n3++] = 94;
                byArray2[n3++] = (byte)(byArray[n2] + 64);
                byArray2[n3++] = 62;
            } else {
                byArray2[n3++] = byArray[n2];
            }
            ++n2;
        }
        if (!this.silentReceive) {
            string = new String(byArray2, 0, n3);
            this.text.append(string);
        } else {
            string = "";
        }
        this.counter.incrementValue(n);
        this.textCount += n;
        return string;
    }

    public void readData() {
        try {
            while (this.owner.open && this.owner.in.available() > 0) {
                int n = this.owner.in.read(this.buffer);
                if (n > 0) {
                    if (n > this.buffer.length) {
                        System.out.println(String.valueOf(this.owner.port.getName()) + ": Input buffer overflow!");
                    }
                    String string = this.displayText(this.buffer, n);
                    if (this.owner.lineMonitor) {
                        this.owner.transmitter.sendString(string);
                    }
                }
                if (this.delay <= 0) continue;
                long l = System.currentTimeMillis() + (long)this.delay;
                long l2 = 0L;
                while (l2 < l) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    l2 = System.currentTimeMillis();
                }
            }
            this.owner.ctlSigs.DA = false;
            this.owner.ctlSigs.showErrorValues();
            return;
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(this.owner.port.getName()) + ": Cannot read input stream");
            return;
        }
    }
}

