//
//  ViewController.swift
//  fileApp2
//
//  Created by Mason Akershoek on 9/26/24.
//

import UIKit

class ViewController: UIViewController, UIDocumentInteractionControllerDelegate{
    //var documentInteractionController: UIDocumentInteractionController!
    
    // UI Elements Definition
    var folderField:UITextField!
    var myTitle:UILabel!
    var submitButton:UIButton!
    var outputLab:UILabel!
    @IBOutlet var sv:UIScrollView!
    
    override func viewDidLoad() {
//        print("GG")
//        let myFilesPath = "/Users/masonakershoek/Desktop/pdfs"
//        let enumerator = FileManager.default.enumerator(atPath:myFilesPath)
//        var files = enumerator?.allObjects as! [String]
//        files.sort()
        
        super.viewDidLoad()
        // Title Label Definition
        myTitle = UILabel()
        myTitle!.text = "PDF Viewer"
        myTitle!.frame = CGRect(x: view.bounds.width/2-100, y: 50, width: 200, height: 50)
        myTitle!.textColor = UIColor.black
        myTitle!.textAlignment = .center
        view!.addSubview(myTitle!)
        
        // Text Field Definition
        folderField = UITextField()
        folderField.placeholder = "Enter Folder Name"
        folderField!.frame = CGRect(x: view.bounds.width/2-100, y: 100, width: 200, height: 50)
        folderField!.borderStyle = .roundedRect
        view!.addSubview(folderField!)
        
        // Submit Button Definition
        submitButton = UIButton()
        submitButton!.setTitle("Submit", for:UIControl.State.normal)
        submitButton.frame = CGRect(x: view.bounds.width/2-50, y: 160, width: 100, height: 25)
        submitButton.setTitleColor(.black, for:  UIControl.State.normal)
        submitButton.backgroundColor = .gray
        submitButton.layer.cornerRadius = 12
        submitButton.addTarget(self, action: #selector (openFolder), for: UIControl.Event.touchUpInside)
        view!.addSubview(submitButton!)
        
        outputLab = UILabel()
        outputLab.frame = CGRect(x: view.bounds.width/2-50, y: 180, width:100, height:50)
        view!.addSubview(outputLab!)
    }
    
    @IBAction func openFolder(){
        let path:String = folderField.text!
        if FileManager.default.fileExists(atPath: path){
            let enumerator = FileManager.default.enumerator(atPath:path)
            var files = enumerator?.allObjects as! [String]
            files.sort()
            var pdfNames:[String] = []
            for file in files{
                if file.hasSuffix(".pdf"){
                    pdfNames.append(file)
                }
            }
            addButtons(pdfNames)
        }
    }
    
    @IBAction func addButtons(_ files:[String]){
        var offet:Int = 0
        for name in files {
            let tmp:UIButton = UIButton()
            tmp.setTitle(name, for: UIControl.State.normal)
            tmp.frame = CGRect(x: 10, y: offet, width: 100, height: 50)
            tmp.addTarget(self, action: #selector(showDocument), for: UIControl.Event.touchUpInside)
            tmp.backgroundColor = .blue
            self.sv.addSubview(tmp)
            offet += 100
        }
        
    }
    
    @IBAction func showDocument(_ sender: UIButton?) {
        var fileName:String = sender!.title(for:UIControl.State.normal)!
        let documentsPath:String = NSSearchPathForDirectoriesInDomains(.documentDirectory,.userDomainMask,true)[0]
        let filePath = documentsPath + "/" + fileName
        
        FileManager.default.createFile(atPath: filePath, contents: nil, attributes: nil)
        let x:String = (folderField.text! + "/" + fileName)
        let handle:FileHandle? = FileHandle(forReadingAtPath: x)
        let outfile:FileHandle? = FileHandle(forWritingAtPath: filePath)
        while true{
            var data:Data? = nil
            do{
                data = try handle!.read(upToCount:50000)
            } catch {
                break
            }
            if data == nil {break}
            outfile!.write(data!)
        }
        do {
            try handle!.close()
            try outfile!.close()
        }catch {
            
        }
        let url:NSURL? = NSURL(fileURLWithPath: fileName, relativeTo: URL(fileURLWithPath: documentsPath))
        let pdfv:UIDocumentInteractionController? = UIDocumentInteractionController(url: url! as URL)
        pdfv!.delegate = self
        pdfv!.presentPreview(animated: true)
    }
    
    func documentInteractionControllerViewControllerForPreview (_ controller:UIDocumentInteractionController) -> UIViewController {
        return self
    }

}

